'==============================================================================
'
' Simple example of an application that has a dialog and requires absolutely
' no API calls
'
'==============================================================================

#COMPILE exe

%IDOK       = 1
%IDCANCEL   = 2
%IDTEXT     = 100
%BS_DEFAULT = 1

'------------------------------------------------------------------------------
' Global variable to recieve the user name

GLOBAL UserName AS STRING

'------------------------------------------------------------------------------

CALLBACK FUNCTION OkButton()

  CONTROL GET TEXT CBHNDL, %IDTEXT TO UserName
  DIALOG END CBHNDL, 1

END FUNCTION

CALLBACK FUNCTION CancelButton()

  DIALOG END CBHNDL, 0

END FUNCTION

'------------------------------------------------------------------------------

FUNCTION PBMAIN () AS LONG

  $REGISTER NONE

  LOCAL hDlg   AS LONG
  LOCAL result AS LONG

' ** Create a new dialog template
  DIALOG NEW 0, "What is your name?", ,, 160, 50 TO hDlg

' ** Add controls to it
  CONTROL ADD TEXTBOX, hDlg, %IDTEXT, "", 14,  12, 134, 12, 0
  CONTROL ADD BUTTON, hDlg, %IDOK, "OK", 34, 32, 40, 14, %BS_DEFAULT CALL OkButton
  CONTROL ADD BUTTON, hDlg, %IDCANCEL, "Cancel", 84, 32, 40, 14, 0 CALL CancelButton

' ** Display the dialog
  DIALOG SHOW MODAL hDlg TO result

' ** Check the result
  IF result THEN
    MSGBOX "Hello " & UserName
  END IF

END FUNCTION
