'============================================================
'  SAMPLE05.BAS by Bob Benson
'  using PowerBASIC DLL Compiler
'============================================================
#REGISTER NONE ' disables automatic assignment of REGISTER
               ' variables.  You can still use the REGISTER
               ' statement to explicitly define REGISTER
               ' variables in your code.  It has been noted
               ' that using REGISTER variables may not be
               ' compatable with certain C/C++ procedures.

#COMPILE DLL "PBLineScales.dll" 'specify desired name and path

#DIM ALL       ' Using #DIM ALL requires you to declare all
               ' variables and arrays before they are used
               ' in a program - same as OPTION EXPLICIT

#DEBUG ERROR ON  ' use error checking during development
                 ' turn off when finished, as this will make
                 ' your code smaller and faster.


#INCLUDE "Win32API.inc"   'headers for Windows
#INCLUDE "VCType32.inc"   'and Visual Cadd APIs
#INCLUDE "VCMain32.inc"
#INCLUDE "VCDlg32.inc"

'--- Define Equates and Global Variable usage here ----------
%ON      =   1
%OFF     =   0
%YES     =   1

%IDTEXT1 = 101  'identifier for textbox - LTScaleWorld
%IDTEXT2 = 102  'identifier for textbox - LTScaleDevice

GLOBAL iError%                        'AS INTEGER
GLOBAL hDlg&                          'AS LONG
GLOBAL xDlg&, yDlg&, xxDlg&, yyDlg&   'AS LONG
GLOBAL lMyDlgStyle&                   'AS LONG
GLOBAL lMyDlgExStyle&                 'AS LONG
GLOBAL ToolBarUsed&                   'AS LONG
GLOBAL SpeedBarUsed&                  'AS LONG
GLOBAL dLTScaleWorld#                 'AS DOUBLE
GLOBAL dLtScaleDevice#                'AS DOUBLE
GLOBAL sMyDlgStyleName$               'AS STRING

GLOBAL vcClient AS RECT 'WinTYPE nTop& nLeft& nRight& nBottom&
GLOBAL vcFrame  AS RECT 'WinTYPE nTop& nLeft& nRight& nBottom&

'--- Declare procedures here --------------------------------
DECLARE SUB GetMyCommandLine
DECLARE SUB SetupMyRibalog
DECLARE SUB ResizeMyRibalog
DECLARE CALLBACK FUNCTION MyLineScales_Ok
DECLARE CALLBACK FUNCTION MyLineScales_Cancel
'============================================================
SUB MyLineScales ALIAS "LineScales" () EXPORT
'------------------------------------------------------------
GetMyCommandLine   'get style and sizes from command line

IF iError% THEN
   EXIT SUB        'exit if not proper command line format
ELSE
   SetupMyRibalog  'setup dialog template
END IF

' if style has DS_ABSALIGN bit set, then we are using
' screen coordinates and need to calculate the appropriate
' dialog units - resize and locate the ribalog as required
IF (lMyDlgStyle& AND %DS_ABSALIGN) THEN ReSizeMyRibalog

'  turn speedbar and/or toolbar off, if used
IF SpeedBarUsed& THEN EnableWindow VCGetToolBar(%TBTOP), %OFF
IF ToolBarUsed& THEN EnableWindow VCGetToolBar(%TBLEFT), %OFF

' display ribalog and wait for a button to be activated
DIALOG SHOW MODAL hDlg&

' program resumes here when ribalog is destroyed
' turn speedbar and/or toolbar back on, if used
IF SpeedBarUsed& THEN EnableWindow VCGetToolBar(%TBTOP), %ON
IF ToolBarUsed& THEN EnableWindow VCGetToolBar(%TBLEFT), %ON

END SUB
'============================================================
SUB GetMyCommandLine
'------------------------------------------------------------
LOCAL lCount    AS LONG
LOCAL lIndex    AS LONG
LOCAL sTemp     AS STRING
LOCAL szCmdLine AS ASCIIZ * 256

' get command line from VCadd
CALL VCGetDllRunCmdLine (iError%, szCmdLine$)

' get number of items in command line
lCount& = PARSECOUNT (szCmdLine$)
IF lCount& <> 3 THEN 'exit if not three items
   iError% = %YES    'set error flag so main procedure
   EXIT SUB          'will exit as well
END IF

' setup dialog style and get dialog units if used
FOR lIndex& = 1 TO lCount&
  sTemp$ = PARSE$(szCmdLine$, lIndex&)
  SELECT CASE lIndex&
    CASE 1  'border type
      sMyDlgStyleName$ = UCASE$(sTemp$)
      SELECT CASE sMyDlgStyleName$
        CASE "FLAT", "FLAT1", "FLAT2"
          lMyDlgStyle& = %WS_POPUP _
                      OR %DS_SETFONT _
                      OR %DS_NOFAILCREATE
        CASE "BORDER"
          lMyDlgStyle& = %WS_POPUP _
                      OR %DS_SETFONT _
                      OR %DS_NOFAILCREATE _
                      OR %DS_MODALFRAME _
                      OR %DS_3DLOOK
        CASE ELSE
          iError% = %YES 'set error flag and quit if first
          EXIT SUB       'entry is not FLAT or BORDER
      END SELECT
    CASE 2  'ribalog width or zero
      xxDlg& = VAL (sTemp$)
    CASE 3  'ribalog height or zero
      yyDlg& = VAL (sTemp$)
  END SELECT
NEXT lIndex&

' get VCadd frame and client sizes - pixels
CALL GetWindowRect (VCGethWndFrame, vcFrame)
CALL GetClientRect (VCGethWndFrame, vcClient)

' if VCadd frame is on left monitor or extends over on the
' right monitor or command line dialog units are zero, then
' we need to assign temporary sizes for the dialog template
' and set the DS_ABSALIGN bit in the style setting.  This
' will also be tested later to see if resize procedure needs
' to be used.
IF xxDlg& = 0 _
   OR vcFrame.nLeft& < -4 _
   OR vcFrame.nRight > GetSystemMetrics(%SM_CXSCREEN) THEN
      xxDlg& = 533 : yyDlg& = 18
      lMyDlgStyle& = lMyDlgStyle& OR %DS_ABSALIGN

ELSE   'otherwise the dialog units from command line are used
   xDlg& = 0 : yDlg& = 0               'reset for client area
   IF yyDlg& = 0 THEN yyDlg& = 18 'assign height if not input
   'adjust width for current right side of client area
   xxDlg& = ROUND(vcClient.nRight& * (xxDlg& / 800) + .5, 0)
   SELECT CASE sMyDlgStyleName$
     CASE "FLAT2"
       yDlg& = 1            'drop for FLAT2 style
     CASE "BORDER"
       xxDlg& = xxDlg& - 4  'reduce width for border frame
   END SELECT
END IF

' reset flags and get current speedbar and toolbar status
SpeedBarUsed& = %OFF : ToolBarUsed& = %OFF
IF VCGetToolBar(%TBTOP) THEN SpeedBarUsed& = %ON
IF VCGetToolBar(%TBLEFT) THEN ToolBarUsed& = %ON

END SUB
'============================================================
SUB SetupMyRibalog
'------------------------------------------------------------
LOCAL sLTScaleWorld$         'AS STRING
LOCAL sLTScaleDevice$        'AS STRING
LOCAL iDisplayDecimalValue%  'AS INTEGER
LOCAL sFormat$               'AS STRING

' get current number of deimal places to display
iDisplayDecimalValue% = VCGetDisplayDecimalValue (iError%)

' setup for FOMAT$ statments
IF iDisplayDecimalValue% THEN
   sFormat$ = "0." + STRING$ (iDisplayDecimalValue%, "0")
ELSE
   sFormat$ = ""
END IF

' get current VCadd setting
dLTScaleWorld#  = VCGetLTScaleWorld (iError%)
dLTScaleDevice# = VCGetLTScaleDevice (iError%)

' format as a string for display in text boxes
sLTScaleWorld$  = FORMAT$(dLTScaleWorld#, sFormat$)
sLTScaleDevice$ = FORMAT$(dLTScaleDevice#, sFormat$)

'--- create the dialog template -----------------------------
' VCGethWndFrame returns the handle for VCadd
' no caption text with our ribalog style
DIALOG NEW VCGethWndFrame, "", _
           xDlg&, yDlg&, xxDlg&, yyDlg&, _
           lMyDlgStyle&, lMyDlgExStyle& TO hDlg&

'--- create the controls ------------------------------------
' create the static controls (labels) immediately before the
' real control so that the keyboard accelerators (hotkeys)
' switch focus to the real control.

' main ribalog label - $CR puts text on two lines
CONTROL ADD LABEL,   hDlg&, -1, _
                     "Line Scale" + $CR + "Settings", _
                     2, 1, 39, 17

'  add vertical etched line to all styles except FLAT
IF sMyDlgStyleName$ <> "FLAT" THEN
   CONTROL ADD LABEL,   hDlg&, -1, "", _
                        51, 0, 0, 19, _
                        %SS_ETCHEDVERT
END IF

' label for LTScaleWorld textbox with 'W' as hotkey
CONTROL ADD LABEL,   hDlg&, -1, "&World Scale:",_
                     64, 5, 44, 10

' LTScaleWorld textbox - sunken - tabstop - right justify
CONTROL ADD TEXTBOX, hDlg&, %IDTEXT1, sLTScaleWorld$, _
                     108, 3, 50, 12, _
                     %ES_RIGHT OR %WS_TABSTOP, _
                     %WS_EX_CLIENTEDGE

' label for LTScaleDevice textbox with 'D' as hotkey
CONTROL ADD LABEL,   hDlg&, -1, "&Device Scale:", _
                     170, 5, 48, 10

' LTScaleDevice textbox - sunken - tabstop - right justify
CONTROL ADD TEXTBOX, hDlg&, %IDTEXT2, sLTScaleDevice$, _
                     218, 3, 50, 12, _
                     %ES_RIGHT OR %WS_TABSTOP, _
                     %WS_EX_CLIENTEDGE

'  add vertical etched line to all styles except FLAT
IF sMyDlgStyleName$  <> "FLAT" THEN
   CONTROL ADD LABEL,   hDlg&, -1, "", _
                        278, 0, 0, 19, _
                        %SS_ETCHEDVERT
END IF

' OK button with 'O' as hotkey - set to default button
CONTROL ADD BUTTON,  hDlg&, %IDOK, "&OK", _
                     288, 2, 18, 14, _
                     %BS_DEFAULT _
                     CALL MyLineScales_Ok      'use callback

' Cancel button with 'C' as hotkey
CONTROL ADD BUTTON,  hDlg&, %IDCANCEL, "&Cancel", _
                     316, 2, 30, 14, _
                     CALL MyLineScales_Cancel  'use callback

END SUB
'============================================================
SUB ResizeMyRibalog
'------------------------------------------------------------
LOCAL xPix&, yPix&, xxPix&, yyPix&
LOCAL xBorder&, yBorder&, yScreen&, yEdge&
LOCAL lOrgin AS iPoint2D
LOCAL lSize  AS iPoint2D

' get current border sizes and screen height
xBorder& = GetSystemMetrics(%SM_CXSIZEFRAME)
yBorder& = GetSystemMetrics(%SM_CYSIZEFRAME)
yScreen& = GetSystemMetrics(%SM_CYSCREEN)
yEdge&   = GetSystemMetrics(%SM_CYEDGE)

' calculate new origin - pixels
xPix& = vcFrame.nLeft& + xBorder&
yPix& = vcFrame.nBottom& - vcClient.nBottom& - yBorder&

' set Ribalog Width to current client area size
xxPix& = VCClient.nRight

' Get Ribalog Height to use (pixels)
IF SpeedBarUsed& THEN
   CALL VCGetRibalogSize (iError%, lOrgin, lSize)
   yyPix& = lSize.y&  'use current VCadd size
ELSE
   yyPix& = 33        'use 33 if no speedbar
END IF

' if DS_MODALFRAME bit is not set then adjust
' size and location for FLAT2 style
IF ISFALSE (lMyDlgStyle& AND %DS_MODALFRAME) THEN
   SELECT CASE sMyDlgStyleName$
     CASE "FLAT2"
        yPix& = yPix& + yEdge&
       yyPix& = yyPix& - yEdge& - 1
     CASE "FLAT", "FLAT1"
       'no adjustment used at this time
   END SELECT
ELSE
   yyPix& = yyPix& + yEdge&  'adjust for 3D border
   IF vcFrame.nBottom& < yScreen& THEN
      DECR yPix&             'adjust for not full screen
   END IF
END IF

'--- convert PIXELS to DIALOG UNITS
DIALOG PIXELS hDlg&,  xPix&,  yPix& TO UNITS  xDlg&,  yDlg&
DIALOG PIXELS hDlg&, xxPix&, yyPix& TO UNITS xxDlg&, yyDlg&

'--- set dialog to new location
DIALOG SET LOC  hDlg&,  xDlg&,  yDlg&

'--- set dialog to new size
DIALOG SET SIZE hDlg&, xxDlg&, yyDlg&

END SUB
'============================================================
CALLBACK FUNCTION MyLineScales_Ok ()
'------------------------------------------------------------
LOCAL sTemp AS STRING

'--- get text from ScaleWorld text box
CONTROL GET TEXT hDlg&, %IDTEXT1 TO sTemp$

'--- update VCadd LTScaleWorld setting if a new value
IF VAL (sTemp$) <> dLTScaleWorld# THEN
   CALL VCSetLTScaleWorld (iError%, VAL (sTemp$))
END IF

'--- get text from ScaleDevice text box
CONTROL GET TEXT hDlg&, %IDTEXT2 TO sTemp$

'--- update VCadd LTScaleDevice setting if a new value
IF VAL (sTemp$) <> dLTScaleDevice# THEN
   CALL VCSetLTScaleDevice (iError%, VAL (sTemp$))
END IF

DIALOG END hDlg&  '--- destroy the dialog

END FUNCTION
'============================================================
CALLBACK FUNCTION MyLineScales_Cancel ()
'------------------------------------------------------------
DIALOG END hDlg&  '--- destroy the dialog

END FUNCTION
'------------------------------------------------------------









                                                                                                                                                                                                                                                               _




                                                             