'============================================================
'  SAMPLE04.BAS by Bob Benson
'  using PowerBASIC DLL Compiler
'============================================================
#COMPILE DLL "Sample04.dll" 'specify desired name and path
#INCLUDE "Sample04.inc"

'--- Declare Visual Cadd API calls here ---------------------
DECLARE FUNCTION VCGetDllRunCmdLine LIB "VCMAIN32.DLL" _
          ALIAS "VCGetDllRunCmdLine" (iError AS INTEGER, _
          szPath AS ASCIIZ) AS INTEGER

DECLARE SUB VCSetColorIndex LIB "VCMAIN32.DLL" _
     ALIAS "VCSetColorIndex" (iError AS INTEGER, _
     BYVAL i AS INTEGER)

DECLARE SUB VCSetLayerIndex LIB "VCMAIN32.DLL" _
     ALIAS "VCSetLayerIndex" (iError AS INTEGER, _
     BYVAL i AS INTEGER)

DECLARE SUB VCSetLineTypeIndex LIB "VCMAIN32.DLL" _
     ALIAS "VCSetLineTypeIndex" (iError AS INTEGER, _
     BYVAL i AS INTEGER)

DECLARE SUB VCSetLineWidthIndex LIB "VCMAIN32.DLL" _
     ALIAS "VCSetLineWidthIndex" (iError AS INTEGER, _
     BYVAL i AS INTEGER)


'--- Define Equates and Variable usage here -----------------
GLOBAL szCmdLine AS ASCIIZ * 256
GLOBAL sTemp AS STRING
GLOBAL lTemp AS LONG

'------------------------------------------------------------
SUB MySetProperties ALIAS "SetProperties" () EXPORT
'------------------------------------------------------------
LOCAL lCount AS LONG
LOCAL lIndex AS LONG

CALL VCGetDllRunCmdLine (iError%, szCmdLine$)

lCount& = PARSECOUNT (szCmdLine$)

DO

  INCR lIndex&

  sTemp$ = UCASE$(PARSE$(szCmdLine$, lIndex&))

  INCR lIndex&

  iTemp% = VAL(PARSE$(szCmdLine$, lIndex&))

  SELECT CASE sTemp$

    CASE "YC", "CURRENTLAYER", "CL", "LAYERPROP"
      CALL VCSetLayerIndex (iError%, iTemp%)

    CASE "LC", "LINECOLOR", "CP", "COLORPROP"
      CALL VCSetColorIndex (iError%, iTemp%)

    CASE "LT", "LINETYPE", "TP", "TYPEPROP"
      CALL VCSetLineTypeIndex (iError%, iTemp%)

    CASE "LW", "LINEWIDTH", "WP", "WIDTHPROP"
      CALL VCSetLineWidthIndex (iError%, iTemp%)

  END SELECT

LOOP WHILE lIndex& < lCount&

END SUB
               