'============================================================================
'  VCLINK.BAS -- Visual Cadd 3.0.1 Documentation for PB/DLL6.0
'  Sample code for loading Visual Cadd DLLs if not an add-on application.
'  Use similar code in WINMAIN function if compiling to an EXE.
'  Loading order is based on Visual Cadd VCLINK32 documentation.
'  Last Update: October 1, 1999
'============================================================================
'
'  Generic DLL Template
'  Copyright (c) 1997-99 by PowerBASIC, Inc.
'  Some portions Copyright (C) 1994 Microsoft Corporation
'
'  LIBMAIN (or it's synonym DllMain) function Purpose:
'
'    User-defined function called by Windows each time a DLL is loaded into,
'    and unloaded from, memory. In 32-bit Windows, LibMain is called each
'    time a DLL is loaded by an application or process.  Your code should
'    never call LibMain.
'
'    hInstance is the DLL instance handle.  This handle is used by the
'    calling application to identify the DLL being called.
'
'    fdwReason specifies a flag indicating why the DLL entry-point
'    (LibMain) is being called.
'
'    lpvReserved specifies further aspects of the DLL initialization
'    and cleanup.  If fdwReason is %DLL_PROCESS_ATTACH, lpvReserved is
'    NULL (zero) for dynamic loads and non-NULL for static loads.  If
'    fdwReason is %DLL_PROCESS_DETACH, lpvReserved is NULL if LibMain
'    has been called by using the FreeLibrary API call and non-NULL if
'    LibMain has been called during process termination.
'
' Return
'
'    If LibMain is called with %DLL_PROCESS_ATTACH, your LibMain function
'    should return a zero (0) if any part of your initialization process
'    fails or a one (1) if no errors were encountered.  If a zero is
'    returned, Windows will abort and unload the DLL from memory. When
'    LibMain is called with any other value than %DLL_PROCESS_ATTACH, the
'    return value is ignored.
'
'============================================================================

#COMPILE DLL

#DIM ALL  'requires you to declare ALL variables and arrays before they are
          'used in a program.

#INCLUDE "WIN32API.INC"  'optional if the following code is used

#IF NOT %DEF (%WINAPI)

  %DLL_PROCESS_DETACH = 0
  %DLL_PROCESS_ATTACH = 1
  %DLL_THREAD_ATTACH  = 2
  %DLL_THREAD_DETACH  = 3

  DECLARE FUNCTION LoadLibrary LIB "KERNEL32.DLL" _
            ALIAS "LoadLibraryA" (lpLibFileName AS ASCIIZ) AS LONG
  DECLARE FUNCTION FreeLibrary LIB "KERNEL32.DLL" _
            ALIAS "FreeLibrary" (BYVAL hLibModule AS LONG) AS LONG

#ENDIF

GLOBAL hInstVCMAIN32 AS LONG
GLOBAL hInstVCTOOL32 AS LONG
GLOBAL hInstVCTRAN32 AS LONG
GLOBAL hInstVCDLG32  AS LONG

'============================================================================

FUNCTION LibMain (BYVAL hInstance   AS LONG, _
                  BYVAL fwdReason   AS LONG, _
                  BYVAL lpvReserved AS LONG) EXPORT AS LONG

  DIM lError AS LOCAL LONG

  SELECT CASE fwdReason&

    CASE %DLL_PROCESS_ATTACH
      'Indicates that the DLL is being loaded by another process (a DLL
      'or EXE is loading the DLL).  DLLs can use this opportunity to
      'initialize any instance or global data, such as arrays.

      hInstVCMAIN32& = LoadLibrary ("VCMAIN32.DLL")
      hInstVCTOOL32& = LoadLibrary ("VCTOOL32.DLL")
      hInstVCDLG32&  = LoadLibrary ("VCDLG32.DLL")
      hInstVCTRAN32& = LoadLibrary ("VCTRAN32.DLL")

      'If the LoadLibrary function succeeds, the return value is the
      'handle to the module.  If the function fails, the return value
      'is NULL.  To get extended error information, call GetLastError.

      LibMain& = 1   'success!

      'LibMain& = 0   'failure!
      EXIT FUNCTION

    CASE %DLL_PROCESS_DETACH
      'Indicates that the DLL is being unloaded or detached from the
      'calling application.  DLLs can take this opportunity to clean
      'up all resources for all threads attached and known to the DLL.

      lError& = FreeLibrary (hInstVCMAIN32&)
      lError& = FreeLibrary (hInstVCTOOL32&)
      lError& = FreeLibrary (hInstVCTRAN32&)
      lError& = FreeLibrary (hInstVCDLG32&)

      'If the FreeLibrary function succeeds, the return value is nonzero.
      'If the function fails, the return value is zero.  To get extended
      'error information, call GetLastError.

      LibMain& = 1   'success!

      'LibMain& = 0   'failure!
      EXIT FUNCTION

    CASE %DLL_THREAD_ATTACH
      'Indicates that the DLL is being loaded by a new thread in the
      'calling application.  DLLs can use this opportunity to
      'initialize any thread local storage (TLS).

       LibMain& = 1   'success!

      'LibMain& = 0   'failure!
      EXIT FUNCTION

    CASE %DLL_THREAD_DETACH
      'Indicates that the thread is exiting cleanly.  If the DLL has
      'allocated any thread local storage, it should be released.

       LibMain& = 1   'success!

      'LibMain& = 0   'failure!
      EXIT FUNCTION

  END SELECT

  ' Any message which is not handled in the above SELECT CASE reaches
  ' this point and is unknown.

END FUNCTION





              