'============================================================
'  SAMPLE03.BAS by Bob Benson
'  using PowerBASIC DLL Compiler
'============================================================
#COMPILE DLL "Sample03.dll" 'specify desired name and path
#INCLUDE "Sample03.inc"

'#INCLUDE "WIN32API.INC"

'#INCLUDE "VCType32.INC"
'#INCLUDE "VCMAIN32.INC"
'#INCLUDE "VCLINK32.INC"
'#INCLUDE "VCTOOL32.INC"
'#INCLUDE "VCDLG32.INC"
'#INCLUDE "VCTRAN32.INC"

'--- Declare Visual Cadd API calls here ---------------------

DECLARE FUNCTION VCGetDimItemShow LIB "VCMAIN32.DLL" _
          ALIAS "VCGetDimItemShow" (iError AS INTEGER, _
          BYVAL i AS INTEGER) AS INTEGER

DECLARE SUB VCSetDimItemShow LIB "VCMAIN32.DLL" _
     ALIAS "VCSetDimItemShow" (iError AS INTEGER, _
     BYVAL i AS INTEGER, BYVAL tf AS INTEGER)

DECLARE SUB VCSetAllDimPartsOn LIB "VCMAIN32.DLL" _
     ALIAS "VCSetAllDimPartsOn" (iError AS INTEGER)

DECLARE FUNCTION VCGetSymSnap LIB "VCMAIN32.DLL" _
          ALIAS "VCGetSymSnap" (iError AS INTEGER) AS INTEGER

DECLARE SUB VCSetSymSnap LIB "VCMAIN32.DLL" _
     ALIAS "VCSetSymSnap" (iError AS INTEGER, _
     BYVAL tf AS INTEGER)

DECLARE FUNCTION VCGetDisplayDistFormat LIB "VCMAIN32.DLL" _
          ALIAS "VCGetDisplayDistFormat" (iError AS INTEGER) _
          AS INTEGER

DECLARE SUB VCSetDisplayDistFormat LIB "VCMAIN32.DLL" _
     ALIAS "VCSetDisplayDistFormat" (iError AS INTEGER, _
     BYVAL iF_ AS INTEGER)

DECLARE SUB VCSetDimDistFormat LIB "VCMAIN32.DLL" _
     ALIAS "VCSetDimDistFormat" (iError AS INTEGER, _
     BYVAL iF_ AS INTEGER)

'--- Define Equates and Variable usage here -----------------

' Dimension items
%DIMLINE       = 0
%DIMLEFTARROW  = 1
%DIMRIGHTARROW = 2
%DIMLEFTEXT    = 3
%DIMRIGHTEXT   = 4
%DIMTEXT       = 5

' Display Unit
%InDec    = 0  'Decimal Inches
%FtInDec  = 1  'Decimal Feet & Inches - Feet in API docs
%FtDec    = 2  'Decimal Feet - Feet & Inches in API docs
%InFrac   = 3  'Fractional Inches
%FtInFrac = 4  'Fractional Feet & Inches - Feet in API docs
%FtFrac   = 5  'Fractional Feet - Feet & Inches in API docs
%Mil      = 6  'Millimeter
%Cen      = 7  'Centimeter
%Met      = 8  'Meter
%AngDeg   = 9  'Decimal Degrees               DimAngleFormat
%AngDMS   = 10 'Degrees Minutes Seconds       DimAngleFormat
'   V3
%Mile     = 20 'Mile - not in API docs
%Kilo     = 21 'Kilometer - not in API docs


GLOBAL iTemp AS INTEGER
'------------------------------------------------------------
SUB MyAllDimPartsOn ALIAS "AllDimPartsOn" () EXPORT
'------------------------------------------------------------
CALL VCSetAllDimPartsOn (iError%)
END SUB

'------------------------------------------------------------
SUB MyHideDimLine ALIAS "HideDimLine" () EXPORT
'------------------------------------------------------------
CALL VCSetDimItemShow (iError%, %DIMLINE, %OFF)
END SUB

'------------------------------------------------------------
SUB MyShowDimLine ALIAS "ShowDimLine" () EXPORT
'------------------------------------------------------------
CALL VCSetDimItemShow (iError%, %DIMLINE, %ON)
END SUB

'------------------------------------------------------------
SUB MyToggleDimLine ALIAS "ToggleDimLine" () EXPORT
'------------------------------------------------------------
CALL VCSetDimItemShow (iError%, %DIMLINE, _
     1 - VCGetDimItemShow (iError%, %DIMLINE))
END SUB

'------------------------------------------------------------
SUB MyHideDimLtArrow ALIAS "HideDimLtArrow" () EXPORT
'------------------------------------------------------------
CALL VCSetDimItemShow (iError%, %DIMLEFTARROW, %OFF)
END SUB

'------------------------------------------------------------
SUB MyShowDimLtArrow ALIAS "ShowDimLtArrow" () EXPORT
'------------------------------------------------------------
CALL VCSetDimItemShow (iError%, %DIMLEFTARROW, %ON)
END SUB

'------------------------------------------------------------
SUB MyToggleDimLtArrow ALIAS "ToggleDimLtArrow" () EXPORT
'------------------------------------------------------------
CALL VCSetDimItemShow (iError%, %DIMLEFTARROW, _
     1 - VCGetDimItemShow (iError%, %DIMLEFTARROW))
END SUB

'------------------------------------------------------------
SUB MyHideDimRtArrow ALIAS "HideDimRtArrow" () EXPORT
'------------------------------------------------------------
CALL VCSetDimItemShow (iError%, %DIMRIGHTARROW, %OFF)
END SUB

'------------------------------------------------------------
SUB MyShowDimRtArrow ALIAS "ShowDimRtArrow" () EXPORT
'------------------------------------------------------------
CALL VCSetDimItemShow (iError%, %DIMRIGHTARROW, %ON)
END SUB

'------------------------------------------------------------
SUB MyToggleDimRtArrow ALIAS "ToggleDimRtArrow" () EXPORT
'------------------------------------------------------------
CALL VCSetDimItemShow (iError%, %DIMRIGHTARROW, _
     1 - VCGetDimItemShow (iError%, %DIMRIGHTARROW))
END SUB

'------------------------------------------------------------
SUB MyHideDimLtExt ALIAS "HideDimLtExt" () EXPORT
'------------------------------------------------------------
CALL VCSetDimItemShow (iError%, %DIMLEFTEXT, %OFF)
END SUB

'------------------------------------------------------------
SUB MyShowDimLtExt ALIAS "ShowDimLtExt" () EXPORT
'------------------------------------------------------------
CALL VCSetDimItemShow (iError%, %DIMLEFTEXT, %ON)
END SUB

'------------------------------------------------------------
SUB MyToggleDimLtExt ALIAS "ToggleDimLtExt" () EXPORT
'------------------------------------------------------------
CALL VCSetDimItemShow (iError%, %DIMLEFTEXT, _
     1 - VCGetDimItemShow (iError%, %DIMLEFTEXT))
END SUB

'------------------------------------------------------------
SUB MyHideDimRtExt ALIAS "HideDimRtExt" () EXPORT
'------------------------------------------------------------
CALL VCSetDimItemShow (iError%, %DIMRIGHTEXT, %OFF)
END SUB

'------------------------------------------------------------
SUB MyShowDimRtExt ALIAS "ShowDimRtExt" () EXPORT
'------------------------------------------------------------
CALL VCSetDimItemShow (iError%, %DIMRIGHTEXT, %ON)
END SUB

'------------------------------------------------------------
SUB MyToggleDimRtExt ALIAS "ToggleDimRtExt" () EXPORT
'------------------------------------------------------------
CALL VCSetDimItemShow (iError%, %DIMRIGHTEXT, _
     1 - VCGetDimItemShow (iError%, %DIMRIGHTEXT))
END SUB

'------------------------------------------------------------
SUB MyHideDimText ALIAS "HideDimText" () EXPORT
'------------------------------------------------------------
CALL VCSetDimItemShow (iError%, %DIMTEXT, %OFF)
END SUB

'------------------------------------------------------------
SUB MyShowDimText ALIAS "ShowDimText" () EXPORT
'------------------------------------------------------------
CALL VCSetDimItemShow (iError%, %DIMTEXT, %ON)
END SUB

'------------------------------------------------------------
SUB MyToggleDimText ALIAS "ToggleDimText" () EXPORT
'------------------------------------------------------------
CALL VCSetDimItemShow (iError%, %DIMTEXT, _
     1 - VCGetDimItemShow (iError%, %DIMTEXT))
END SUB

'------------------------------------------------------------
SUB MyToggleHandlePts ALIAS "ToggleHandlePts" () EXPORT
'------------------------------------------------------------
iTemp% = 1 - VCGetHandlePt(iError%)  'calculate new setting
CALL VCSetHandlePt (iError%, iTemp%) 'toggle Handle Points
CALL VCSetSymSnap (iError%, iTemp%)  'set SymSnap to match
END SUB

'------------------------------------------------------------
SUB MyToggleDisplayUnits ALIAS "ToggleDisplayUnits" () EXPORT
'------------------------------------------------------------
iTemp% = VCGetDisplayDistFormat(iError%) 'get current setting
IF iTemp% = %Met THEN           'if current setting is Meters
   iTemp% = %FtInFrac           'change to Fractional Ft & In
ELSE
   iTemp% = %Met          'anything else is changed to Meters
END IF
CALL VCSetDisplayDistFormat (iError%, iTemp%)    'set display
CALL VCSetDimDistFormat (iError%, iTemp%)     'set dimensions
END SUB

