'============================================================
'  SAMPLE03.INC by Bob Benson
'  using PowerBASIC DLL Compiler
'============================================================
#REGISTER NONE ' disables automatic assignment of REGISTER
               ' variables.  You can still use the REGISTER
               ' statement to explicitly define REGISTER
               ' variables in your code.  It has been noted
               ' that using REGISTER variables may not be
               ' compatable with certain C/C++ procedures.

'#COMPILE DLL "Sample02.dll" 'specify desired name and path

#DIM ALL       ' Using #DIM ALL requires you to declare all
               ' variables and arrays before they are used
               ' in a program - same as OPTION EXPLICIT

#DEBUG ERROR ON  ' use error checking during development
                 ' turn off when finished, as this will make
                 ' your code smaller and faster.

'--- Declare Visual Cadd API calls here ---------------------

DECLARE FUNCTION VCGetFillDisplay LIB "VCMAIN32.DLL" _
          ALIAS "VCGetFillDisplay" (iError AS INTEGER) _
          AS INTEGER

DECLARE FUNCTION VCGetHatchDisplay LIB "VCMAIN32.DLL" _
          ALIAS "VCGetHatchDisplay" (iError AS INTEGER) _
          AS INTEGER

DECLARE FUNCTION VCGetLineWidthDisplay LIB "VCMAIN32.DLL" _
          ALIAS "VCGetLineWidthDisplay" (iError AS INTEGER) _
          AS INTEGER

DECLARE FUNCTION VCGetLineTypeDisplay LIB "VCMAIN32.DLL" _
          ALIAS "VCGetLineTypeDisplay" (iError AS INTEGER) _
          AS INTEGER

DECLARE FUNCTION VCGetPointDisplay LIB "VCMAIN32.DLL" _
          ALIAS "VCGetPointDisplay" (iError AS INTEGER) _
          AS INTEGER

DECLARE FUNCTION VCGetConstPt LIB "VCMAIN32.DLL" _
          ALIAS "VCGetConstPt" (iError AS INTEGER) _
          AS INTEGER

DECLARE FUNCTION VCGetHandlePt LIB "VCMAIN32.DLL" _
          ALIAS "VCGetHandlePt" (iError AS INTEGER) _
          AS INTEGER

DECLARE SUB VCSetFillDisplay LIB "VCMAIN32.DLL" _
     ALIAS "VCSetFillDisplay" (iError AS INTEGER, _
     BYVAL tf AS INTEGER)

DECLARE SUB VCSetHatchDisplay LIB "VCMAIN32.DLL" _
     ALIAS "VCSetHatchDisplay" (iError AS INTEGER, _
     BYVAL tf AS INTEGER)

DECLARE SUB VCSetLineWidthDisplay LIB "VCMAIN32.DLL" _
     ALIAS "VCSetLineWidthDisplay" (iError AS INTEGER, _
     BYVAL tf AS INTEGER)

DECLARE SUB VCSetLineTypeDisplay LIB "VCMAIN32.DLL" _
     ALIAS "VCSetLineTypeDisplay" (iError AS INTEGER, _
     BYVAL tf AS INTEGER)

DECLARE SUB VCSetPointDisplay LIB "VCMAIN32.DLL" _
     ALIAS "VCSetPointDisplay" (iError AS INTEGER, _
     BYVAL tf AS INTEGER)

DECLARE SUB VCSetConstPt LIB "VCMAIN32.DLL" _
     ALIAS "VCSetConstPt" (iError AS INTEGER, _
     BYVAL tf AS INTEGER)

DECLARE SUB VCSetHandlePt LIB "VCMAIN32.DLL" _
     ALIAS "VCSetHandlePt" (iError AS INTEGER, _
     BYVAL tf AS INTEGER)

'--- Define Equates and Variable usage here -----------------

%ON  = 1
%OFF = 0

GLOBAL iError AS INTEGER

'------------------------------------------------------------
SUB MyHideFill ALIAS "HideFill" () EXPORT
'------------------------------------------------------------
CALL VCSetFillDisplay (iError%, %OFF)
END SUB

'------------------------------------------------------------
SUB MyShowFill ALIAS "ShowFill" () EXPORT
'------------------------------------------------------------
CALL VCSetFillDisplay (iError%, %ON)
END SUB

'------------------------------------------------------------
SUB MyToggleFill ALIAS "ToggleFill" () EXPORT
'------------------------------------------------------------
CALL VCSetFillDisplay (iError%, 1-VCGetFillDisplay(iError%))
END SUB

'------------------------------------------------------------
SUB MyHideHatch ALIAS "HideHatch" () EXPORT
'------------------------------------------------------------
CALL VCSetHatchDisplay (iError%, %OFF)
END SUB

'------------------------------------------------------------
SUB MyShowHatch ALIAS "ShowHatch" () EXPORT
'------------------------------------------------------------
CALL VCSetHatchDisplay (iError%, %ON)
END SUB

'------------------------------------------------------------
SUB MyToggleHatch ALIAS "ToggleHatch" () EXPORT
'------------------------------------------------------------
CALL VCSetHatchDisplay (iError%, _
     1 - VCGetHatchDisplay(iError%))
END SUB

'------------------------------------------------------------
SUB MyHideLineWidth ALIAS "HideLineWidth" () EXPORT
'------------------------------------------------------------
CALL VCSetLineWidthDisplay (iError%, %OFF)
END SUB

'------------------------------------------------------------
SUB MyShowLineWidth ALIAS "ShowLineWidth" () EXPORT
'------------------------------------------------------------
CALL VCSetLineWidthDisplay (iError%, %ON)
END SUB

'------------------------------------------------------------
SUB MyToggleLineWidth ALIAS "ToggleLineWidth" () EXPORT
'------------------------------------------------------------
CALL VCSetLineWidthDisplay (iError%, _
     1 - VCGetLineWidthDisplay(iError%))
END SUB

'------------------------------------------------------------
SUB MyHideLineType ALIAS "HideLineType" () EXPORT
'------------------------------------------------------------
CALL VCSetLineTypeDisplay (iError%, %OFF)
END SUB

'------------------------------------------------------------
SUB MyShowLineType ALIAS "ShowLineType" () EXPORT
'------------------------------------------------------------
CALL VCSetLineTypeDisplay (iError%, %ON)
END SUB

'------------------------------------------------------------
SUB MyToggleLineType ALIAS "ToggleLineType" () EXPORT
'------------------------------------------------------------
CALL VCSetLineTypeDisplay (iError%, _
     1 - VCGetLineTypeDisplay(iError%))
END SUB

'------------------------------------------------------------
SUB MyHideConstPts ALIAS "HideConstPts" () EXPORT
'------------------------------------------------------------
CALL VCSetConstPt (iError%, %OFF)
END SUB

'------------------------------------------------------------
SUB MyShowConstPts ALIAS "ShowConstPts" () EXPORT
'------------------------------------------------------------
CALL VCSetConstPt (iError%, %ON)
END SUB

'------------------------------------------------------------
SUB MyToggleConstPts ALIAS "ToggleConstPts" () EXPORT
'------------------------------------------------------------
CALL VCSetConstPt (iError%, 1 - VCGetConstPt(iError%))
END SUB

'------------------------------------------------------------
SUB MyHideRefPts ALIAS "HideRefPts" () EXPORT
'------------------------------------------------------------
CALL VCSetHandlePt (iError%, %OFF)
END SUB

'------------------------------------------------------------
SUB MyShowRefPts ALIAS "ShowRefPts" () EXPORT
'------------------------------------------------------------
CALL VCSetHandlePt (iError%, %ON)
END SUB

'------------------------------------------------------------
SUB MyToggleRefPts ALIAS "ToggleRefPts" () EXPORT
'------------------------------------------------------------
CALL VCSetHandlePt (iError%, 1 - VCGetHandlePt(iError%))
END SUB

'------------------------------------------------------------
SUB MyHideStdPts ALIAS "HideStdPts" () EXPORT
'------------------------------------------------------------
CALL VCSetPointDisplay (iError%, %OFF)
END SUB

'------------------------------------------------------------
SUB MyShowStdPts ALIAS "ShowStdPts" () EXPORT
'------------------------------------------------------------
CALL VCSetPointDisplay (iError%, %ON)
END SUB

'------------------------------------------------------------
SUB MyToggleStdPts ALIAS "ToggleStdPts" () EXPORT
'------------------------------------------------------------
CALL VCSetPointDisplay (iError%, _
     1 - VCGetPointDisplay(iError%))
END SUB

              