'============================================================================
'  VCLINK.BAS -- Visual Cadd 4.0.0 Documentation for PB/DLL6.0
'  Sample code for loading Visual Cadd DLLs if not an add-on application.
'  Use similar code in WINMAIN function if compiling to an EXE.
'  Loading order is based on Visual Cadd VCLINK32 documentation.
'  Last Update: August 28, 2001
'============================================================================
'
'  Generic DLL Template
'  Copyright (c) 1997-99 by PowerBASIC, Inc.
'  Some portions Copyright (C) 1994 Microsoft Corporation
'
'  LIBMAIN (or it's synonym DllMain) function Purpose:
'
'    User-defined function called by Windows each time a DLL is loaded into,
'    and unloaded from, memory. In 32-bit Windows, LibMain is called each
'    time a DLL is loaded by an application or process.  Your code should
'    never call LibMain.
'
'    hInstance is the DLL instance handle.  This handle is used by the
'    calling application to identify the DLL being called.
'
'    fdwReason specifies a flag indicating why the DLL entry-point
'    (LibMain) is being called.
'
'    lpvReserved specifies further aspects of the DLL initialization
'    and cleanup.  If fdwReason is %DLL_PROCESS_ATTACH, lpvReserved is
'    NULL (zero) for dynamic loads and non-NULL for static loads.  If
'    fdwReason is %DLL_PROCESS_DETACH, lpvReserved is NULL if LibMain
'    has been called by using the FreeLibrary API call and non-NULL if
'    LibMain has been called during process termination.
'
' Return
'
'    If LibMain is called with %DLL_PROCESS_ATTACH, your LibMain function
'    should return a zero (0) if any part of your initialization process
'    fails or a one (1) if no errors were encountered.  If a zero is
'    returned, Windows will abort and unload the DLL from memory. When
'    LibMain is called with any other value than %DLL_PROCESS_ATTACH, the
'    return value is ignored.
'
'============================================================================


'#COMPILE DLL     'DLL or EXE - specify desired name and path if desired
'#COMPILE EXE     ' default is same name and directory as source
#COMPILE EXE

#REGISTER NONE   ' disables automatic assignment of REGISTER
                 ' variables.  You can still use the REGISTER
                 ' statement to explicitly define REGISTER
                 ' variables in your code.  It has been noted
                 ' that using REGISTER variables may not be
                 ' compatible with certain C/C++ procedures.

#DIM ALL         ' Using #DIM ALL requires you to declare all
                 ' variables and arrays before they are used
                 ' in a program - same as OPTION EXPLICIT

#DEBUG ERROR ON  ' use error checking ON during development
                 ' turn OFF when finished, as this will make
                 ' your code smaller and faster.


#OPTION VERSION4 'Win95/98 (default)

'#INCLUDE "WIN32API.INC"  ' remove leading remark to use WIN32API.INC
                          ' optional if the following code is included
'----------------------------------------------------------------------------
#IF NOT %DEF (%WINAPI)    ' only is compiled if WIN32API.INC not used

  %DLL_PROCESS_DETACH = 0
  %DLL_PROCESS_ATTACH = 1
  %DLL_THREAD_ATTACH  = 2
  %DLL_THREAD_DETACH  = 3

  DECLARE FUNCTION LoadLibrary LIB "KERNEL32.DLL" _
            ALIAS "LoadLibraryA" (lpLibFileName AS ASCIIZ) AS LONG
  DECLARE FUNCTION FreeLibrary LIB "KERNEL32.DLL" _
            ALIAS "FreeLibrary" (BYVAL hLibModule AS LONG) AS LONG
  DECLARE FUNCTION GetProcAddress LIB "KERNEL32.DLL" _
            ALIAS "GetProcAddress" (BYVAL hModule AS LONG, _
                                          lpProcName AS ASCIIZ) AS LONG
#ENDIF
'----------------------------------------------------------------------------
%YES = 1
%NO  = 0
%VCEXPORT = %NO 'set to %YES if VC Procedures are called from another EXE/DLL

GLOBAL hInstVCBASE32 AS LONG
GLOBAL hInstVCDB32   AS LONG
GLOBAL hInstVCMAIN32 AS LONG
GLOBAL hInstVCTOOL32 AS LONG
GLOBAL hInstVCDLG32  AS LONG
GLOBAL hInstVCTRAN32 AS LONG

#INCLUDE "VCTYPE32.inc"

#INCLUDE "ProcList.inc" ' remove leading remarks for VC procedures to be used
                        '
#INCLUDE "VCMain_1.bas" ' NOTE: 
#INCLUDE "VCMain_2.bas" ' Creating a DLL with %VCEXPORT = %YES and
#INCLUDE "VCTool32.bas" ' all procedures showing in ProcList.inc (all
#INCLUDE "VCDlg32.bas"  ' leading remarks removed) would provide the  
#INCLUDE "VCTran32.bas" ' same functionality as VCLink32.DLL if desired.

'============================================================================
#IF %DEF(%PB_DLL)  'this code is used if compiling a DLL
'============================================================================
FUNCTION LibMain (BYVAL hInstance   AS LONG, _
                  BYVAL fwdReason   AS LONG, _
                  BYVAL lpvReserved AS LONG) EXPORT AS LONG

  DIM lError AS LOCAL LONG

  SELECT CASE fwdReason

    CASE %DLL_PROCESS_ATTACH
      'Indicates that the DLL is being loaded by another process (a DLL
      'or EXE is loading the DLL).  DLLs can use this opportunity to
      'initialize any instance or global data, such as arrays.

      hInstVCBASE32 = LoadLibrary ("VCBASE32.DLL")
      hInstVCDB32   = LoadLibrary ("VCDB32.DLL")
      hInstVCMAIN32 = LoadLibrary ("VCMAIN32.DLL")
      hInstVCTOOL32 = LoadLibrary ("VCTOOL32.DLL")
      hInstVCDLG32  = LoadLibrary ("VCDLG32.DLL")
      hInstVCTRAN32 = LoadLibrary ("VCTRAN32.DLL")

      'If the LoadLibrary function succeeds, the return value is the
      'handle to the module.  If the function fails, the return value
      'is NULL.  To get extended error information, call GetLastError.

      LibMain = 1   'success!

      'LibMain = 0   'failure!
      EXIT FUNCTION

    CASE %DLL_PROCESS_DETACH
      'Indicates that the DLL is being unloaded or detached from the
      'calling application.  DLLs can take this opportunity to clean
      'up all resources for all threads attached and known to the DLL.

      lError = FreeLibrary (hInstVCBASE32)
      lError = FreeLibrary (hInstVCDB32)
      lError = FreeLibrary (hInstVCMAIN32)
      lError = FreeLibrary (hInstVCTOOL32)
      lError = FreeLibrary (hInstVCDLG32)
      lError = FreeLibrary (hInstVCTRAN32)

      'If the FreeLibrary function succeeds, the return value is nonzero.
      'If the function fails, the return value is zero.  To get extended
      'error information, call GetLastError.

      LibMain = 1   'success!

      'LibMain = 0   'failure!
      EXIT FUNCTION

    CASE %DLL_THREAD_ATTACH
      'Indicates that the DLL is being loaded by a new thread in the
      'calling application.  DLLs can use this opportunity to
      'initialize any thread local storage (TLS).

       LibMain = 1   'success!

      'LibMain = 0   'failure!
      EXIT FUNCTION

    CASE %DLL_THREAD_DETACH
      'Indicates that the thread is exiting cleanly.  If the DLL has
      'allocated any thread local storage, it should be released.

       LibMain = 1   'success!

      'LibMain = 0   'failure!
      EXIT FUNCTION

  END SELECT

  ' Any message which is not handled in the above SELECT CASE reaches
  ' this point and is unknown.

END FUNCTION
#ENDIF

'============================================================================
#IF %DEF(%PB_EXE)  'this code is used if compiling an EXE
'============================================================================
FUNCTION WINMAIN (BYVAL CurInst AS LONG, _
                  BYVAL PrvInst AS LONG, _
                  CmdLine AS ASCIIZ PTR, _
                  BYVAL CmdShow AS LONG) EXPORT AS LONG

  LOCAL lError AS LONG
  LOCAL initCount AS LONG
  
  hInstVCBASE32 = LoadLibrary ("VCBASE32.DLL")
  hInstVCDB32   = LoadLibrary ("VCDB32.DLL")
  hInstVCMAIN32 = LoadLibrary ("VCMAIN32.DLL")
  hInstVCTOOL32 = LoadLibrary ("VCTOOL32.DLL")
  hInstVCDLG32  = LoadLibrary ("VCDLG32.DLL")
  hInstVCTRAN32 = LoadLibrary ("VCTRAN32.DLL")

' In order to access routines in the Visual CADD engine from an external
' stand-alone interface, the DLL must be initialized to set up a drawing
' database and establish all necessary functionality. The full API set is
' available to the application after initializing the DLL. The Visual CADD
' engine should be cleared from memory with VCTerminate when the stand-alone
' application terminates. 
'
' Applications that require the Visual CADD dialogs, i.e. Print Dialog or
' ribalogs, should also initialize the dialog routines with VCInitDialogs.
' These should then be cleared with VCTerminateDialogs.
'
' VCInit is not required when the application requires the Visual CADD
' interface, i.e. a user tool or add-on spell checker. VCTerminate should
' only be used by stand-alone applications which have explicate accessed
' the DLL with VCInit.

  CALL VCInit
  CALL VCInitDialogs

  initCount = VCGetInitCount
  IF initCount <= 0 THEN
     MSGBOX "Error: Visual Cadd not loaded properly."
     EXIT FUNCTION
  ELSE
     MSGBOX "initCount = " + STR$(initCount),, "Visual Cadd Initialized"
  END IF
 
  CALL VCTerminateDialogs
  CALL VCTerminate

  lError = FreeLibrary (hInstVCBASE32)
  lError = FreeLibrary (hInstVCDB32)
  lError = FreeLibrary (hInstVCMAIN32)
  lError = FreeLibrary (hInstVCTOOL32)
  lError = FreeLibrary (hInstVCDLG32)
  lError = FreeLibrary (hInstVCTRAN32)

END FUNCTION
#ENDIF
           