'----------------------------------------------------------------------------
'
'  VCTYPE32.INC -- Visual Cadd 4.0.0 Declarations for PB/DLL6.0
'
'  This file is not compatible with Visual Basic.  It uses data types
'  which are not natively supported in Visual Basic such as
'  unsigned integers and ASCIIZ strings.
'
'  Last Update: November 18, 2000
'----------------------------------------------------------------------------

' Visual CADD Public Constants

' Entity Kinds

%UNKNOWN            = 0
%LINE2D             = 1
%ARC2D              = 2
%CIRCLE2D           = 3
%ELLIPSE2D          = 4
%BEZIER2D           = 5
%POINT2D            = 6
%SYMBOL2D           = 7
%TEXT2D             = 8
%DIMLINEAR2D        = 9
%DIMANGULAR2D       = 10
%DIMRADIAL2D        = 11
%DIMDIAMETER2D      = 12
%FILL2D             = 13
%HATCH2D            = 14
%ATTRIBUTE2D        = 15
%INTERPCURV2D       = 16
%MINTERPCURV2D      = 17
%ELLIPTICALARC2D    = 18
%CONTINUOUSLINE2D   = 19
%CONTINUOUSBEZIER2D = 20
%LEADER2D           = 21
%REFFRAME2D         = 22
%ORDDIM2D           = 23
%POLYGON3D          = 101
%POINT3D            = 102
%LINE3D             = 103
%SYMBOL3D           = 104
%CONTINUOUSLINE3D   = 105

TYPE iPoint2D
  x AS LONG
  y AS LONG
END TYPE

TYPE fPoint2D
  x AS SINGLE
  y AS SINGLE
END TYPE

TYPE lPoint2D
  x AS LONG
  y AS LONG
END TYPE

TYPE Point2D
  x AS DOUBLE
  y AS DOUBLE
END TYPE

TYPE Point3D
  x AS DOUBLE
  y AS DOUBLE
  z AS DOUBLE
END TYPE

TYPE EAttr
  iColor       AS INTEGER  'Color' is a reserved word in PB
  iLayer       AS INTEGER
  iLinetype    AS INTEGER
  iLinewidth   AS INTEGER
  fWidth       AS SINGLE
  bByLayerFlag AS BYTE
END TYPE

#IF NOT %DEF (%WINAPI)

  TYPE RECT
    nLeft   AS LONG  'Left' is a reseved word in PB
    nTop    AS LONG
    nRight  AS LONG  'Right' is a reseved word in PB
    nBottom AS LONG
  END TYPE

#ENDIF

TYPE DoubleRect
  dLeft   AS DOUBLE  'Left' is a reserved word in PB
  dTop    AS DOUBLE
  dRight  AS DOUBLE  'Right' is a reserved word in PB
  dBottom AS DOUBLE
END TYPE

'======================================================================================
' Defines for VCSetAlertApp, VCSetAlertAppEx,
'              VCSetAlertAppDll & VCSetAlertAppDllEx iCode0 Parameter
'======================================================================================
' the following are bit-wise "OR"ed together for the iCode0
'
%ALERT_APP_ALL = 0???

%ALERT_APP_UTOOL_MOUSEDOWN = &H00000001???
$ALERT_APP_UTOOL_MOUSEDOWN_DLL = "MouseDown"

%ALERT_APP_UTOOL_MOUSEMOVE = &H00000002???
$ALERT_APP_UTOOL_MOUSEMOVE_DLL = "MouseMove"

%ALERT_APP_UTOOL_ABORT = &H00000004???
$ALERT_APP_UTOOL_ABORT_DLL = "Abort"

%ALERT_APP_CMDLINE_CHAR = &H00000008???
$ALERT_APP_CMDLINE_CHAR_DLL = "Char"

%ALERT_APP_CLOSE = &H00000010???
$ALERT_APP_CLOSE_DLL = "AppClose"

%ALERT_APP_UTOOL_PENUP = &H00000020???
$ALERT_APP_UTOOL_PENUP_DLL = "PenUp"
%ALERT_PENUP_CHARCODE = 252

%ALERT_APP_WORLD_CLOSE = &H00000040???
$ALERT_APP_WORLD_CLOSE_DLL = "DrawingClose"
%ALERT_WORLD_CLOSE_CHARCODE = 253

%ALERT_APP_UTOOL_ERASERUBBER = &H00000080???
$ALERT_APP_UTOOL_ERASERUBBER_DLL = "EraseRubber"
%ALERT_UTOOL_ERASERUBBER_CHARCODE = 255

%ALERT_APP_TOOL_COMPLETE = &H00000100???
$ALERT_APP_TOOL_COMPLETE_DLL = "ToolComplete"
%ALERT_TOOL_COMPLETE_CHARCODE = 254

%ALERT_APP_UTOOL_INIT = &H00000200???
$ALERT_APP_UTOOL_INIT_DLL = "Init"
%ALERT_UTOOL_INIT_CHARCODE = 251

%ALERT_APP_UTOOL_TERMINATE = &H00000400???
$ALERT_APP_UTOOL_TERMINATE_DLL = "Terminate"
%ALERT_UTOOL_TERMINATE_CHARCODE = 250

%ALERT_APP_FRAME_CLOSE = &H00000800???
$ALERT_APP_FRAME_CLOSE_DLL = "FrameClose"
%ALERT_FRAME_CLOSE_CHARCODE = 249

%ALERT_APP_FRAME_RESIZE = &H00001000???
$ALERT_APP_FRAME_RESIZE_DLL = "FrameResise"
%ALERT_FRAME_RESIZE_CHARCODE = 248

%ALERT_APP_ENTITY_ERASED = &H00002000???
$ALERT_APP_ENTITY_ERASED_DLL = "EntityErased"
%ALERT_APP_ENTITY_ERASED_CHARCODE = 247

%ALERT_APP_ENTITY_SELECT_CHANGE = &H00004000???
$ALERT_APP_ENTITY_SELECT_CHANGE_DLL = "EntitySelectChange"
%ALERT_APP_ENTITY_SELECT_CHANGE_CHARCODE = 246

%ALERT_APP_ACTIVATE = &H00008000???
$ALERT_APP_ACTIVATE_DLL = "Activate"
%ALERT_APP_ACTIVATE_CHARCODE = 245

%ALERT_APP_DEACTIVATE = &H00010000???
$ALERT_APP_DEACTIVATE_DLL = "DeActivate"
%ALERT_APP_DEACTIVATE_CHARCODE = 244

%ALERT_APP_UTOOL_MOUSEUP = &H00020000???
$ALERT_APP_UTOOL_MOUSEUP_DLL = "MouseUp"

%ALERT_APP_WORLD_MOUSEMOVE = &H00040000???
$ALERT_APP_WORLD_MOUSEMOVE_DLL = "WorldMouseMove"
%ALERT_APP_WORLD_MOUSEMOVE_CHARCODE = 243

%ALERT_APP_WORLD_MOUSEDOWN = &H00080000???
$ALERT_APP_WORLD_MOUSEDOWN_DLL = "WorldMouseDown"
%ALERT_APP_WORLD_MOUSEDOWN_CHARCODE = 242

%ALERT_APP_WORLD_MOUSEUP = &H00100000???
$ALERT_APP_WORLD_MOUSEUP_DLL = "WorldMouseUp"
%ALERT_APP_WORLD_MOUSEUP_CHARCODE = 241

%ALERT_APP_WORLD_END_REDRAW = &H00200000???
$ALERT_APP_WORLD_END_REDRAW_DLL = "WorldEndRedraw"
%ALERT_APP_WORLD_END_REDRAW_CHARCODE = 240

%ALERT_APP_WORLD_BEGIN_REDRAW = &H00400000???
$ALERT_APP_WORLD_BEGIN_REDRAW_DLL = "WorldBeginRedraw"
%ALERT_APP_WORLD_BEGIN_REDRAW_CHARCODE = 239

%ALERT_APP_WORLD_BEGIN_PRINT = &H00800000???
$ALERT_APP_WORLD_BEGIN_PRINT_DLL = "WorldBeginPrint"
%ALERT_APP_WORLD_BEGIN_PRINT_CHARCODE = 238

%ALERT_APP_WORLD_END_PRINT = &H01000000???
$ALERT_APP_WORLD_END_PRINT_DLL = "WorldEndPrint"
%ALERT_APP_WORLD_END_PRINT_CHARCODE = 237

%ALERT_APP_TOOL_START = &H02000000???
$ALERT_APP_TOOL_START_DLL = "ToolStart"
%ALERT_APP_TOOL_START_CHARCODE = 236

%ALERT_APP_TOOL_ABORT = &H04000000???
$ALERT_APP_TOOL_ABORT_DLL = "ToolAbort"
%ALERT_APP_TOOL_ABORT_CHARCODE = 235

'======================================================================================
' Defines for VCSetAlertAppEx & VCSetAlertAppDllEx iCode1 Parameter
'======================================================================================
' the following are bit-wise "OR"ed together for the iCode1
'
%ALERT_APP_EX_ALL = &HFFFFFFFF???

%ALERT_APP_EX_PRE_TRANSLATE_GET_MESSAGE = &H00000001???
$ALERT_APP_EX_PRE_TRANSLATE_GET_MESSAGE_DLL = "PreTranslateGetMessage"
%ALERT_APP_EX_PRE_TRANSLATE_GET_MESSAGE_CHARCODE = 233

%ALERT_APP_EX_PRE_TRANSLATE_FRAME_MESSAGE = &H00000002???
$ALERT_APP_EX_PRE_TRANSLATE_FRAME_MESSAGE_DLL = "PreTranslateFrameMessage"
%ALERT_APP_EX_PRE_TRANSLATE_FRAME_MESSAGE_CHARCODE = 232

%ALERT_APP_EX_PRE_TRANSLATE_DIALOG_MESSAGE = &H00000004???
$ALERT_APP_EX_PRE_TRANSLATE_DIALOG_MESSAGE_DLL = "PreTranslateDialogMessage"
%ALERT_APP_EX_PRE_TRANSLATE_DIALOG_MESSAGE_CHARCODE = 231

' VCM_USER_ALERT Posted as the wParam of a WM_COMMAND Message will cause Visual Cadd
' to call the ALERT_APP_EX_USER_ALERT_MESSAGE.  The lParam the user sends in the WM_COMMAND
' message will be sent back to them.  This call can be used to avoid recursion which can
' happen in many of the AlertApp messages such as starting a new tool from within the
' AlertAppToolComplete message.

%ALERT_APP_EX_USER_ALERT_MESSAGE = &H00000008???
$ALERT_APP_EX_USER_ALERT_DLL = "UserAlert"
%ALERT_APP_EX_USER_ALERT_CHARCODE = 230
%VCM_USER_ALERT = 2801

%ALERT_APP_EX_DIALOG_OPEN_MESSAGE = &H00000010???
$ALERT_APP_EX_DIALOG_OPEN_DLL = "DialogOpen"
%ALERT_APP_EX_DIALOG_OPEN_CHARCODE = 229

%ALERT_APP_EX_DIALOG_CLOSE_MESSAGE = &H00000020???
$ALERT_APP_EX_DIALOG_CLOSE_DLL = "DialogClose"
%ALERT_APP_EX_DIALOG_CLOSE_CHARCODE = 228

%ALERT_APP_EX_PRE_TRANSLATE_MDICHILD_MESSAGE = &H00000040???
$ALERT_APP_EX_PRE_TRANSLATE_MDICHILD_MESSAGE_DLL = "PreTranslateChildMessage"
%ALERT_APP_EX_PRE_TRANSLATE_MDICHILD_MESSAGE_CHARCODE = 227

' API calls which use "SymbolIndex", use this parameter for entity section additions
%NONDEFENTITY    = -1
%HATCHFILLENTITY = -2

' VCSetProjection3D Codes
%VIEW3D_FLAT        = 0
%VIEW3D_PARALLEL    = 1
%VIEW3D_PERSPECTIVE = 2

' VCSet3DDisplay Codes
%VIEW3D_WIREFRAME = 0
%VIEW3D_QSHADE    = 1

' VCSetView3DQShadeOptions
%QSHADE_ROUGH           = 0
%QSHADE_EXACT           = 1
%QSHADE_EXACT_AND_SPLIT = 2

' VCChangeView3D Codes
%CHANGE_VIEW3D_LEFT  = 0
%CHANGE_VIEW3D_RIGHT = 1
%CHANGE_VIEW3D_UP    = 2
%CHANGE_VIEW3D_DOWN  = 3

' VC Supported File Types
%FILE_VCD = 0
%FILE_VCS = 1
%FILE_VCA = 2
%FILE_GCD = 3
%FILE_CMP = 4
%FILE_DWG = 5
%FILE_DXF = 6
%FILE_STY = 7
%FILE_VCF = 8
%FILE_EMF = 9
%FILE_WMF = 10

' Conversion Unit Public Constants
%UNIT_INCH = 0
%UNIT_FEET = 1
%UNIT_MM   = 2
%UNIT_CM   = 3
%UNIT_M    = 4
%UNIT_MILE = 10
%UNIT_K    = 11

' Display Unit
%InDec    = 0
%FtInDec  = 1
%FtDec    = 2
%InFrac   = 3
%FtInFrac = 4
%FtFrac   = 5
%Mil      = 6
%Cen      = 7
%Met      = 8
%AngDeg   = 9
%AngDMS   = 10
%AngDM    = 11
%Mile     = 20
%Kilo     = 21

' Dimension Mode
%DIMMODESINGLE      = 0
%DIMMODECUMULATIVE  = 1
%DIMMODEPARTITIONED = 2

' Dimension Direction
%DIMALIGNED    = 1
%DIMHORIZONTAL = 2
%DIMVERTICAL   = 3
%DIMATANANGLE  = 4

' Dimension Tolerance Type
%DIMNOTOLERANCE     = 0
%DIMSTACKEDMINMAX   = 1
%DIMSTACKEDVARIANCE = 2
%DIMFIXEDVARIANCE   = 3

' Dimension Extension Line
%DIMEXTNOSTRETCH = 0
%DIMEXTSTRETCH   = 1

' Dimension Unit Type (Linear, Radial, or Diameter Dimensions)
%DIMINCHES      = 1
%DIMFEET        = 2
%DIMMETERS      = 3
%DIMMILLIMETERS = 4
%DIMCENTIMETERS = 5
%DIMFTIN        = 6

' Dimension Unit Type (Angular Dimensions)
%DIMANGLEFORMATDECIMAL = 0
%DIMANGLEFORMATMINUTES = 1

' Dimension Arrow Types
%DIMARROWREGNOFILL    = 0
%DIMARROWREGFILLED    = 1
%DIMARROWREGOPEN      = 2
%DIMARROWNOTCHED      = 3
%DIMARROWSLASH        = 4
%DIMARROWCIRCLENOFILL = 5
%DIMARROWCIRCLEFILL   = 6

' Dimension Text
%DIMTEXTINLINE    = 0
%DIMTEXTABOVELINE = 1
%DIMTEXTFREEFLOAT = 2
%DIMOUTSIDELINE   = 3

' Dimension Text Rotation
%DIMTEXTROTATIONALIGNED    = 0
%DIMTEXTROTATIONHORIZONTAL = 1

' Linear Dimension Line Position
%DIMLINELEFT  = 0
%DIMLINERIGHT = 1

' Dimension Proximity Mode
%DIMLINENOPROXFIX = 0
%DIMLINEPROXFIX   = 1

' Dimension Arrow Mode
%DIMARROWNOFLIP = 0
%DIMARROWFLIP   = 1

' Dimension items
%DIMLINE       = 0
%DIMLEFTARROW  = 1
%DIMRIGHTARROW = 2
%DIMLEFTEXT    = 3
%DIMRIGHTEXT   = 4
%DIMTEXT       = 5

' Datum modes
%DATUMNONE = 0
%DATUMXY   = 1
%DATUMX    = 2
%DATUMY    = 3

' Justify modes
%JUSTIFY_CENTER = 67
%JUSTIFY_LEFT   = 76
%JUSTIFY_RIGHT  = 82

' Symbol explode layers
%INDIVIDUAL_LAYER = 0
%PLACEMENT_LAYER  = 1
%CURRENT_LAYER    = 2

' Autocad Import Unit Types
%ACAD_UNIT_INCH  = 0
%ACAD_UNIT_FEET  = 1
%ACAD_UNIT_MILL  = 2
%ACAD_UNIT_CENT  = 3
%ACAD_UNIT_METER = 4

' Printer/Plotter definitions
%PRINTMODE = 0
%PLOTMODE  = 1

%FITTOPAPER  = 0
%CURRENTVIEW = 1
%SCALE       = 2

%PORTRAITMODE  = 0
%LANDSCAPEMODE = 1

%METRICUNITS  = 0
%ENGLISHUNITS = 1

%PORTCOM1 = 0
%PORTCOM2 = 1
%PORTCOM3 = 2
%PORTCOM4 = 3
%PORTLPT1 = 4
%PORTLPT2 = 5
%PORTLPT3 = 6
%PORTFILE = 7

%BAUD110   = 0
%BAUD300   = 1
%BAUD1200  = 2
%BAUD2400  = 3
%BAUD4800  = 4
%BAUD9600  = 5
%BAUD19200 = 6
%BAUD38400 = 7
%BAUD57600 = 8

%DATABITS7 = 0
%DATABITS8 = 1

%PARITYODD  = 0
%PARITYEVEN = 1
%PARITYNONE = 2

%STOPBITS1 = 0
%STOPBITS2 = 1

TYPE PrintStruct
  iPrintMode        AS INTEGER
  PageSize          AS Point2D
  Margins           AS DoubleRect
  dScale            AS DOUBLE
  Origin            AS Point2D
  iScaleMode        AS INTEGER
  iOrientation      AS INTEGER
  dRotation         AS DOUBLE
  iPrintToFile      AS INTEGER
  iSelectionOnly    AS INTEGER
  iDateStamp        AS INTEGER
  iFastPreview      AS INTEGER
  iAllColorsToBlack AS INTEGER
  iPaperUnit        AS INTEGER
END TYPE

TYPE PlotStruct
  iPort         AS INTEGER  'Port' is a reserved word in PB
  iBaudRate     AS INTEGER
  iDataBits     AS INTEGER
  iParity       AS INTEGER  'Parity' is a reserved word in PB
  iStopBits     AS INTEGER
  iNumPens      AS INTEGER
  iNumCarousels AS INTEGER
  iDPI          AS INTEGER
  iUseCarousels AS INTEGER
  iUseLLOrigin  AS INTEGER
  iSortColors   AS INTEGER
  iOptimize     AS INTEGER
  iBufferOutput AS INTEGER
END TYPE

' VCGetToolbar constants
%TBNONE   = 0   ' no toolbar
%TBTOP    = 1   ' the main speedbar
%TBLEFT   = 2   ' the tool palette
%TBRIGHT  = 3   ' not used
%TBBOTTOM = 4   ' the status bar
                         